<?php if($items->count() > 0): ?>
    <table class="table table-box pml-table table-log"
        current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page), false); ?>"
    >
        <tr>
            <th><?php echo e(trans('messages.recipient'), false); ?></th>
            <th><?php echo e(trans('messages.ip_address'), false); ?></th>
            <th><?php echo e(trans('messages.campaign'), false); ?></th>
            <th><?php echo e(trans('messages.sending_server'), false); ?></th>
            <th><?php echo e(trans('messages.area'), false); ?></th>
            <th><?php echo e(trans('messages.created_at'), false); ?></th>
            <th></th>
        </tr>
        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <span class="no-margin kq_search"><?php echo e($item->trackingLog->subscriber->email, false); ?></span>
                    <span class="text-muted second-line-mobile"><?php echo e(trans('messages.recipient'), false); ?></span>
                </td>
                <td>
                    <span class="no-margin kq_search"><?php echo e($item->ip_address, false); ?></span>
                    <span class="text-muted second-line-mobile"><?php echo e(trans('messages.ip_address'), false); ?></span>
                </td>
                <td>
                    <span class="no-margin kq_search"><?php echo e(is_null($item->trackingLog->campaign) ? 'N/A' : $item->trackingLog->campaign->name, false); ?></span>
                    <span class="text-muted second-line-mobile"><?php echo e(trans('messages.campaign'), false); ?></span>
                </td>
                <td>
                    <span class="no-margin kq_search"><?php echo e(is_null($item->trackingLog->sendingServer) ? '#' : $item->trackingLog->sendingServer->name, false); ?></span>
                    <span class="text-muted second-line-mobile"><?php echo e(trans('messages.sending_server'), false); ?></span>
                </td>
                <td>
                    <span class="no-margin kq_search"><?php echo e((isset($item->ipLocation) ? $item->ipLocation->name() : ""), false); ?></span>
                    <span class="text-muted second-line-mobile"><?php echo e(trans('messages.area'), false); ?></span>
                </td>
                <td>
                    <span class="no-margin kq_search"><?php echo e(Auth::user()->customer->formatDateTime($item->created_at, 'datetime_full'), false); ?></span>
                    <span class="text-muted second-line-mobile"><?php echo e(trans('messages.created_at'), false); ?></span>
                </td>
                <?php if($item->trackingLog->campaign->openWebhooks()->count()): ?>
                    <td class="text-end">
                        <a href="<?php echo e(action('CampaignController@openLogExecute', [
                            'uid' => $item->trackingLog->campaign->uid,
                            'message_id' => $item->message_id,
                        ]), false); ?>" class="btn btn-light open_log_detail">
                            <?php echo e(trans('messages.webhook.execute_open_callback'), false); ?>

                        </a>                   
                    </td>
                <?php endif; ?>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
    <?php echo $__env->make('elements/_per_page_select', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
		var OpenLogList = {
			webhookPopup: null,

			getWebhookPopup: function(url) {
				if (this.webhookPopup == null) {
					this.webhookPopup = new Popup({
						url: url
					});
				}

				return this.webhookPopup;
			}
		}

		$(function() {
			$('.open_log_detail').on('click', function(e) {
				e.preventDefault();

				var url = $(this).attr('href');

				OpenLogList.getWebhookPopup(url).load();
			});
		})
	</script>
    
<?php elseif(!empty(request()->keyword) || !empty(request()->filters["campaign_uid"])): ?>
    <div class="empty-list">
        <span class="material-symbols-rounded">auto_awesome</span>
        <span class="line-1">
            <?php echo e(trans('messages.no_search_result'), false); ?>

        </span>
    </div>
<?php else: ?>
    <div class="empty-list">
        <span class="material-symbols-rounded">auto_awesome</span>
        <span class="line-1">
            <?php echo e(trans('messages.log_empty_line_1'), false); ?>

        </span>
    </div>
<?php endif; ?>
<?php /**PATH /home/wwalbe/comunicaciones.albertomerani.org/acellemail/resources/views/campaigns/open_log_list.blade.php ENDPATH**/ ?>