<?php $__env->startSection('title', $campaign->name); ?>

<?php $__env->startSection('page_header'); ?>

    <?php echo $__env->make("campaigns._header", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make("campaigns._menu", [
    'menu' => 'open_log',
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h2 class="text-semibold text-primary"><?php echo e(trans('messages.open_log'), false); ?></h2>

<form class="listing-form"
        data-url="<?php echo e(action('CampaignController@openLogListing', $campaign->uid), false); ?>"
        per-page="<?php echo e(Acelle\Model\OpenLog::$itemsPerPage, false); ?>"
    >
        <div class="d-flex top-list-controls top-sticky-content">
            <div class="me-auto">
                <?php if($items->count() >= 0): ?>
                    <div class="filter-box">
                        <span class="filter-group">
                            <span class="title text-semibold text-muted"><?php echo e(trans('messages.sort_by'), false); ?></span>
                            <select class="select" name="sort_order">
                                <option value="created_at"><?php echo e(trans('messages.created_at'), false); ?></option>
                            </select>
                            <input type="hidden" name="sort_direction" value="desc" />
<button type="button" class="btn btn-light sort-direction" data-popup="tooltip" title="<?php echo e(trans('messages.change_sort_direction'), false); ?>" role="button" class="btn btn-xs">
                                <span class="material-symbols-rounded desc">sort</span>
                            </button>
                        </span>
                        <span class="text-nowrap">
                            <input type="text" name="keyword" value="<?php echo e(request()->search_keyword, false); ?>" class="form-control search" placeholder="<?php echo e(trans('messages.type_to_search'), false); ?>" />
                            <span class="material-symbols-rounded">search</span>
                        </span>
                    </div>
                <?php endif; ?>
            </div>
            <div class="text-end">
                <a href="javascript:goToDownLoad('open_logs')" role="button" class="btn btn-secondary">
                    <i class="icon icon-download me-1"></i> <?php echo e(trans('messages.open_log.download'), false); ?>

                </a>
            </div>
        </div>

        <div class="pml-table-container">
        </div>
    </form>

    <script>
        var CampaignLogIndex = {
            getList: function() {
                return makeList({
                    url: '<?php echo e(action('CampaignController@openLogListing', $campaign->uid), false); ?>',
                    container: $('.listing-form'),
                    content: $('.pml-table-container')
                });
            }
        };

        $(function() {
            CampaignLogIndex.getList().load();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.core.frontend', [
    'menu' => 'campaign',
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwalbe/comunicaciones.albertomerani.org/acellemail/resources/views/campaigns/open_log.blade.php ENDPATH**/ ?>