<div class="row mt-5">
    <div class="col-md-8">
        <p class="mb-4"><?php echo e(trans('messages.campaign_open_click_rate_intro'), false); ?></p>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="content-group-sm">
            <div class="d-flex">
                <h4 class="text-semibold mt-0 me-auto"><?php echo e(trans('messages.open_rate'), false); ?></h4>
                <span class="pull-right progress-right-info text-primary">
                    <?php echo e(number_to_percentage($campaign->readCache('UniqOpenRate')), false); ?>

                </span>
            </div>
            <div class="progress progress-sm">
                <div class="progress-bar bg-color3" style="width: <?php echo e(number_to_percentage($campaign->readCache('UniqOpenRate')), false); ?>">
                </div>
            </div>
        </div>
        <div class="stat-table">
            <div class="stat-row">
                <p class="text-muted"><?php echo e(trans('messages.successful_deliveries'), false); ?></p>
                <span class="pull-right num">
                    <?php echo e(number_with_delimiter($campaign->readCache('DeliveredCount')), false); ?>

                    <span class="text-muted2"><?php echo e(number_to_percentage($campaign->readCache('DeliveredRate')), false); ?></span>
                </span>
            </div>
            <div class="stat-row">
                <p class="text-muted"><?php echo e(trans('messages.total_opens'), false); ?></p>
                <span class="pull-right num">
                    <?php echo e(number_with_delimiter($campaign->uniqueOpenCount()), false); ?>

                </span>
            </div>
            <div class="stat-row">
                <p class="text-muted"><?php echo e(trans('messages.uniq_opens'), false); ?></p>
                <span class="pull-right num">
                    <?php echo e(number_with_delimiter($campaign->readCache('UniqOpenCount')), false); ?>

                </span>
            </div>
            <div class="stat-row">
                <p class="text-muted"><?php echo e(trans('messages.last_opened'), false); ?></p>
                <span class="pull-right num">
                    <?php echo e($campaign->lastOpen() ? Auth::user()->customer->formatDateTime($campaign->lastOpen()->created_at, 'datetime_full') : "", false); ?>

                </span>
            </div>
        </div>
        <div class="text-end">
            <a href="<?php echo e(action('CampaignController@openLog', $campaign->uid), false); ?>" class="btn btn-info bg-teal-600"><?php echo e(trans('messages.open_log'), false); ?> <span class="material-symbols-rounded">arrow_forward</span></a>
        </div>
        <br />
    </div>
    <div class="col-md-6">
        <div class="content-group-sm">
            <div class="d-flex">
                <h4 class="text-semibold mt-0 me-auto"><?php echo e(trans('messages.click_rate'), false); ?></h4>
                <div class="progress-right-info text-primary"><?php echo e(number_to_percentage($campaign->readCache('ClickedRate')), false); ?></div>
            </div>
            <div class="progress progress-sm">
                <div class="progress-bar bg-color7" style="width: <?php echo e(number_to_percentage($campaign->readCache('ClickedRate')), false); ?>">
                </div>
            </div>
        </div>
        <div class="stat-table">
            <div class="stat-row">
                <p class="text-muted"><?php echo e(trans('messages.total_clicks'), false); ?></p>
                <span class="pull-right num">
                    <?php echo e(number_with_delimiter($campaign->clickCount()), false); ?>

                </span>
            </div>
            <div class="stat-row">
                <p class="text-muted"><?php echo e(trans('messages.total_opens'), false); ?></p>
                <span class="pull-right num">
                    <?php echo e(number_with_delimiter($campaign->uniqueOpenCount()), false); ?>

                </span>
            </div>
            <div class="stat-row">
                <p class="text-muted"><?php echo e(trans('messages.abuse_reports'), false); ?></p>
                <span class="pull-right num">
                    <?php echo e(number_with_delimiter($campaign->abuseFeedbackCount()), false); ?>

                </span>
            </div>
            <div class="stat-row">
                <p class="text-muted"><?php echo e(trans('messages.last_clicked'), false); ?></p>
                <span class="pull-right num">
                    <?php echo e($campaign->lastClick() ? Auth::user()->customer->formatDateTime($campaign->lastClick()->created_at, 'datetime_full') : "", false); ?>

                </span>
            </div>
        </div>
        <div class="text-end">
            <a href="<?php echo e(action('CampaignController@clickLog', $campaign->uid), false); ?>" class="btn btn-info bg-teal-600"><?php echo e(trans('messages.click_log'), false); ?> <span class="material-symbols-rounded">arrow_forward</span></a>
        </div>
        <br />
    </div>
</div>
<?php /**PATH /home/wwalbe/comunicaciones.albertomerani.org/acellemail/resources/views/campaigns/_open_click_rate.blade.php ENDPATH**/ ?>