<?php $__env->startSection('title', trans('messages.campaigns')); ?>

<?php $__env->startSection('page_header'); ?>

    <div class="page-title">
        <ul class="breadcrumb breadcrumb-caret position-right">
            <li class="breadcrumb-item"><a href="<?php echo e(action("HomeController@index"), false); ?>"><?php echo e(trans('messages.home'), false); ?></a></li>
        </ul>
        <h1>
            <span class="material-symbols-rounded">format_list_bulleted</span> <?php echo e(trans('messages.campaigns'), false); ?></span>
        </h1>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div id="CampaignsIndexContainer" class="listing-form top-sticky"
        data-url="<?php echo e(action('CampaignController@listing'), false); ?>"
        per-page="<?php echo e(Acelle\Model\MailList::$itemsPerPage, false); ?>"
    >
        <div class="d-flex top-list-controls top-sticky-content">
            <div class="me-auto">
                <?php if($campaigns->count() >= 0): ?>
                    <div class="filter-box">
                        <div class="checkbox inline check_all_list">
                            <label>
                                <input type="checkbox" name="page_checked" class="styled check_all">
                            </label>
                        </div>
                        <div class="dropdown list_actions" style="display: none">
                            <button type="button"
                                id="dropdownListActions"
                                class="btn btn-secondary dropdown-toggle"
                                data-bs-toggle="dropdown"
                            >
                                <?php echo e(trans('messages.actions'), false); ?> <span class="number"></span><span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="dropdownListActions">
                                <li>
                                    <a class="action dropdown-item"
                                        link-method="POST"
                                        link-confirm="<?php echo e(trans('messages.restart_campaigns_confirm'), false); ?>" href="<?php echo e(action('CampaignController@resume'), false); ?>">
                                        <span class="material-symbols-rounded me-2">restore</span> <?php echo e(trans("messages.resume"), false); ?></a></li>
                                <li><a class="action dropdown-item"
                                    link-method="POST"
                                    link-confirm="<?php echo e(trans('messages.pause_campaigns_confirm'), false); ?>" href="<?php echo e(action('CampaignController@pause'), false); ?>">
                                    <span class="material-symbols-rounded me-2">motion_photos_pause</span> <?php echo e(trans("messages.pause"), false); ?></a></li>
                                <li><a class="action dropdown-item"
                                    link-method="POST"
                                    link-confirm="<?php echo e(trans('messages.delete_campaigns_confirm'), false); ?>" href="<?php echo e(action('CampaignController@delete'), false); ?>">
                                    <span class="material-symbols-rounded me-2">delete_outline</span> <?php echo e(trans('messages.delete'), false); ?></a></li>
                            </ul>
                        </div>
                        <span class="filter-group">
                            <span class="title text-semibold text-muted"><?php echo e(trans('messages.sort_by'), false); ?></span>
                            <select class="select" name="sort_order">
                                <option value="created_at"><?php echo e(trans('messages.created_at'), false); ?></option>
                                <option value="name"><?php echo e(trans('messages.name'), false); ?></option>
                            </select>
                            <input type="hidden" name="sort_direction" value="desc" />
<button type="button" class="btn btn-light sort-direction" data-popup="tooltip" title="<?php echo e(trans('messages.change_sort_direction'), false); ?>" role="button" class="btn btn-xs">
                                <span class="material-symbols-rounded desc">sort</span>
                            </button>
                        </span>
                        <span class="filter-group">
                            <span class="title text-semibold text-muted"><?php echo e(trans('messages.campaign.status'), false); ?></span>
                            <select class="select" name="status">
                                <option value=""><?php echo e(trans('messages.campaign.status.all'), false); ?></option>
                                <?php $__currentLoopData = Acelle\Model\Campaign::statusSelectOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e(request()->status == $option['value'] ? 'selected' : '', false); ?> value="<?php echo e($option['value'], false); ?>"><?php echo e($option['text'], false); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </span>
                        <span class="text-nowrap search-container">
                            <input type="text" name="keyword" class="form-control search" value="<?php echo e(request()->keyword, false); ?>" value="<?php echo e(request()->keyword, false); ?>" placeholder="<?php echo e(trans('messages.type_to_search'), false); ?>" />
                            <span class="material-symbols-rounded">search</span>
                        </span>
                    </div>
                <?php endif; ?>
            </div>
            <div class="text-end">
                <?php if(Auth::user()->customer->can('create', new Acelle\Model\Campaign())): ?>
                    <a href="<?php echo e(action('CampaignController@selectType'), false); ?>" role="button" class="btn btn-secondary">
                        <span class="material-symbols-rounded">add</span> <?php echo e(trans('messages.create_campaign'), false); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>

        <div id="CampaignsIndexContent" class="pml-table-container">



        </div>
    </div>

    <script>
        var CampaignsIndex = {
            getList: function() {
                return makeList({
                    url: '<?php echo e(action('CampaignController@listing'), false); ?>',
                    container: $('#CampaignsIndexContainer'),
                    content: $('#CampaignsIndexContent')
                });
            }
        };

        $(document).ready(function() {
            CampaignsIndex.getList().load();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.core.frontend', [
    'menu' => 'campaign',
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwalbe/comunicaciones.albertomerani.org/acellemail/resources/views/campaigns/index.blade.php ENDPATH**/ ?>