<pagination class="d-flex align-items-center">
    <label class="small">
        <?php echo trans('messages.pagination.page_of', [
            'pages' => $paginator->lastPage(),
            'page' => $paginator->currentPage(),
        ]); ?>        
    </label>
    <?php if($paginator->lastPage() > 1): ?>
        <ul class="pagination justify-content-end small align-items-center mb-0 ms-4 border-start">
            <li class="page-item <?php echo e($paginator->currentPage() == 1 ? 'disabled' : '', false); ?>">
                <a class="page-link" href="<?php echo e($paginator->url($paginator->currentPage()-1), false); ?>" tabindex="-1" aria-disabled="true" data-page="<?php echo e($paginator->currentPage()-1, false); ?>"><?php echo e(trans('messages.pagination.previous'), false); ?></a>
            </li>

            <?php
                $arr = [];

                if ($paginator->lastPage() > 7) {
                    if ($paginator->currentPage() < 3) {
                        for ($i = 0; $i <= $paginator->currentPage()+3; $i++) {
                            $arr[] = $i;
                        }
                    } else {
                        $arr[] = 0;
                        $arr[] = '...';
                        for ($i = $paginator->currentPage()-2; $i <= $paginator->currentPage()+2 && $i < $paginator->lastPage(); $i++) {
                            $arr[] = $i;
                        }
                    }
                    
                    if ($paginator->currentPage() < $paginator->lastPage() - 4) {
                        $arr[] = '...';
                    }
                    if ($paginator->currentPage() < $paginator->lastPage() - 3) {
                        $arr[] = $paginator->lastPage() - 1;
                    }
                    
                } else {
                    for ($i = 0; $i < $paginator->lastPage(); $i++) {
                        $arr[] = $i;
                    }
                }
            ?>

            <?php $__currentLoopData = $arr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($i !== '...'): ?>
                    <?php if($i == $paginator->currentPage() - 1): ?>
                        <li style="pointer-events: none" class="page-item active" aria-current="page">
                            <span class="page-link">
                                <?php echo e($paginator->currentPage(), false); ?>

                                <span class="sr-only">(current)</span>
                            </span>
                        </li>                    
                    <?php else: ?>
                        <li class="page-item"><a class="page-link" href="<?php echo e($paginator->url($i+1), false); ?>" data-page="<?php echo e($i + 1, false); ?>"><?php echo e($i + 1, false); ?></a></li>
                    <?php endif; ?>
                <?php else: ?>
                    ...
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <li class="page-item <?php echo e($paginator->currentPage() == $paginator->lastPage() ? 'disabled' : '', false); ?>">
            <a class="page-link" href="<?php echo e($paginator->url($paginator->currentPage()+1), false); ?>" data-page="<?php echo e($paginator->currentPage()+1, false); ?>"><?php echo e(trans('messages.pagination.next'), false); ?></a>
            </li>
        </ul>
    <?php endif; ?>
</pagination><?php /**PATH /home/wwalbe/comunicaciones.albertomerani.org/acellemail/resources/views/helpers/_pagination.blade.php ENDPATH**/ ?>