<div class="mt-5 mb-20">
    <div class="d-flex align-items-center">
        <div class="me-2">
            <h3><span class="material-symbols-rounded me-2">schedule</span></h3>
        </div>
        <div>
            <h3><?php echo e(trans('messages.campaign.last_performance'), false); ?></h3>
        </div>
        <div class="ms-auto">
            <div class="d-flex align-items-center">
                <span class="me-3"><?php echo e(trans('messages.performance.period'), false); ?></span>
                <select id="PerformancePeriod" class="select select-control" name="last_performance_time">
                    <option value="24h"><?php echo e(trans('messages.campaign.24_hour'), false); ?></option>
                    <option value="3_days"><?php echo e(trans('messages.campaign.last_3_days'), false); ?></option>
                    <option value="7_days"><?php echo e(trans('messages.campaign.last_7_days'), false); ?></option>
                    <option value="last_month"><?php echo e(trans('messages.campaign.last_month'), false); ?></option>
                </select>
            </div>
        </div>
        
    </div>
    
</div>
<p class="mb-4"><?php echo e(trans('messages.campaign.performance_chart.info'), false); ?></p>
<div class="border shadow-sm rounded">
    <div class="p-3">
        <div id="Campaigns24hChart"
            class=""
            style="width:100%; height:350px;"
        ></div>
    </div>
</div>

<script>
    var Campaigns24hChart = {
        url: '<?php echo e(action('CampaignController@chart24h', $campaign->uid), false); ?>',

        getChart: function() {
            return $('#Campaigns24hChart');
        },

        getTimePeriod: function() {
            return $('[name="last_performance_time"]').val();
        },

        showChart: function() {
            $.ajax({
                method: "GET",
                url: this.url,
                data: {
                    period: this.getTimePeriod()
                }
            })
            .done(function( response ) {
                Campaigns24hChart.renderChart( response );
            });
        },

        renderChart: function(data) {
                // based on prepared DOM, initialize echarts instance
                var my2Chart = echarts.init(Campaigns24hChart.getChart()[0], ECHARTS_THEME);

                var option = {
                    tooltip: {
                        trigger: 'axis'
                    },
                    legend: {
                        data: ['<?php echo e(trans('messages.opened'), false); ?>', '<?php echo e(trans('messages.clicked'), false); ?>']
                    },
                    grid: {
                        left: '3%',
                        right: '4%',
                        bottom: '3%',
                        containLabel: true
                    },
                    toolbox: {
                        show: false
                    },
                    xAxis: {
                        type: 'category',
                        boundaryGap: false,
                        data: data.columns
                    },
                    yAxis: {
                        type: 'value'
                    },
                    series: [
                        {
                            name: '<?php echo e(trans('messages.opened'), false); ?>',
                            type: 'line',
                            itemStyle: {
                                color: '#5cb2b2'
                            },
                            data: data.opened
                        },
                        {
                            name: '<?php echo e(trans('messages.clicked'), false); ?>',
                            type: 'line',
                            itemStyle: {
                                color: '#b26e59'
                            },
                            data: data.clicked
                        }
                    ]
                };

                // use configuration item and data specified to show chart
                my2Chart.setOption(option);
        }
    }

    $(function() {
        $('#PerformancePeriod').select2({
            dropdownAutoWidth : true,
            width: 'auto'
        })

        Campaigns24hChart.showChart();

        $('[name="last_performance_time"]').on('change', function() {
            Campaigns24hChart.showChart();
        });
    })
</script><?php /**PATH /home/wwalbe/comunicaciones.albertomerani.org/acellemail/resources/views/campaigns/_24h_chart.blade.php ENDPATH**/ ?>